//
//  RVApplicationCommands.h
//  CommunicationModule
//
//  Created by Greg Harris on 7/25/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#ifndef CommunicationModule_RVApplicationCommands_h
#define CommunicationModule_RVApplicationCommands_h

#define RVApplicationCommandUnknown @"RVApplicationCommandUnknown"

#define RVApplicationCommandPortNumber @"RVApplicationCommandPortNumber"
#define RVApplicationCommandPortName @"RVApplicationCommandPortName"
#define RVApplicationCommandParser @"RVApplicationCommandParser"

#define RVApplicationCommandRawData @"RVApplicationCommandRawData"
#define RVApplicationCommandRawDataParamData @"RVApplicationCommandRawDataParamData"
#define RVApplicationCommandRawDataParamHint @"RVApplicationCommandRawDataParamHint"

#define RVApplicationCommandAppInfo @"RVApplicationCommandApplicationInfo"
#define RVApplicationCommandAppInfoParamAppName @"appName"
#define RVApplicationCommandAppInfoParamVersion @"version"
#define RVApplicationCommandAppInfoParamUUID @"uuid"
#define RVApplicationCommandAppInfoParamLayers @"layers"
#define RVApplicationCommandAppInfoParamThumbnailFormats @"thumbnailFormats"
#define RVApplicationCommandAppInfoParamStreamFormats @"streamFormats"

#define RVApplicationCommandAppInfoLayerName @"layerName"
#define RVApplicationCommandAppInfoLayerDMXString @"layerDMXString"
#define RVApplicationCommandAppInfoLayerType @"layerType"
#define RVApplicationCommandAppInfoLayerTypeMedia @"media"
#define RVApplicationCommandAppInfoLayerTypeEffects @"effects"
#define RVApplicationCommandAppInfoLayerTypeSlides @"slides"
#define RVApplicationCommandAppInfoLayerTypeAudio @"audio"
#define RVApplicationCommandAppInfoLayerTypeProps @"props"
#define RVApplicationCommandAppInfoStreamFormatJPEG @"jpeg"
#define RVApplicationCommandAppInfoStreamFormatPNG @"png"
#define RVApplicationCommandAppInfoStreamFormatRGB8 @"rgb8"


#define RVApplicationCommandTransportStop @"RVApplicationCommandTransportStop"
#define RVApplicationCommandTransportPlay @"RVApplicationCommandTransportPlay"
#define RVApplicationCommandTransportPause @"RVApplicationCommandTransportPause"
#define RVApplicationCommandTransportRewind @"RVApplicationCommandTransportRewind"
#define RVApplicationCommandTransportFastForward @"RVApplicationCommandTransportFastForward"
#define RVApplicationCommandTransportSeek @"RVApplicationCommandTransportSeek"
#define RVApplicationCommandTransportStep @"RVApplicationCommandTransportStep"
#define RVApplicationCommandTransportTimecode @"RVApplicationCommandTransportTimecode"
#define RVApplicationCommandTransportParameterDirection @"RVApplicationCommandTransportParameterDirection"
#define RVApplicationCommandTransportParameterFrames @"RVApplicationCommandTransportParameterFrames"
#define RVApplicationCommandTransportParameterSpeed @"RVApplicationCommandTransportParameterSpeed"
#define RVApplicationCommandTransportParameterTimecode @"RVApplicationCommandTransportParameterTimecode"

#define RVApplicationCommandCueMedia @"RVApplicationCommandCueMedia"
#define RVApplicationCommandCueMediaParamIndex @"RVApplicationCommandCueMediaParamIndex"
#define RVApplicationCommandCueMediaParamMediaID @"RVApplicationCommandCueMediaParamMediaID"
#define RVApplicationCommandCueMediaParamSetPlayhead @"RVApplicationCommandCueMediaParamSetPlayhead"
#define RVApplicationCommandCueMediaParamInPoint @"RVApplicationCommandCueMediaParamInPoint"
#define RVApplicationCommandCueMediaParamOutPoint @"RVApplicationCommandCueMediaParamOutPoint"
#define RVApplicationCommandCueMediaParamDuration @"RVApplicationCommandCueMediaParamDuration"

#define RVApplicationCommandCuePresentation @"RVApplicationCommandCuePresentation"
#define RVApplicationCommandCuePresentationParamIndex @"RVApplicationCommandCuePresentationParamIndex"
#define RVApplicationCommandCuePresentationParamPresentationID @"RVApplicationCommandCuePresentationParamPresentationID"

#define RVApplicationCommandCuePlaylistItem @"RVApplicationCommandCuePlaylistItem"
#define RVApplicationCommandCuePlaylistItemParamIndex @"RVApplicationCommandCuePlaylistItemParamIndex"
#define RVApplicationCommandCuePlaylistItemParamPlaylistID @"RVApplicationCommandCuePlaylistItemParamPlaylistID"

#define RVApplicationCommandCueAudio @"RVApplicationCommandCueAudio"
#define RVApplicationCommandCueAudioParamIndex @"RVApplicationCommandCueAudioParamIndex"
#define RVApplicationCommandCueAudioParamAudioID @"RVApplicationCommandCueAudioParamAudioID"

#define RVApplicationCommandClearAll @"RVApplicationCommandClearAll"
#define RVApplicationCommandClearLiveVideo @"RVApplicationCommandClearLiveVideo"
#define RVApplicationCommandClearBackground @"RVApplicationCommandClearBackground"
#define RVApplicationCommandClearSlide @"RVApplicationCommandClearSlide"
#define RVApplicationCommandClearProps @"RVApplicationCommandClearProps"
#define RVApplicationCommandClearAudio @"RVApplicationCommandClearAudio"
#define RVApplicationCommandClearLogo @"RVApplicationCommandClearLogo"

#define RVApplicationCommandTimelinePlay @"RVApplicationCommandTimelinePlay"
#define RVApplicationCommandTimelinePause @"RVApplicationCommandTimelinePause"
#define RVApplicationCommandTimelineReset @"RVApplicationCommandTimelineReset"

#define RVApplicationCommandSlideNext @"RVApplicationCommandSlideNext"
#define RVApplicationCommandSlidePrevious @"RVApplicationCommandSlidePrevious"
#define RVApplicationCommandPlaylistItemNext @"RVApplicationCommandPlaylistItemNext"
#define RVApplicationCommandPlaylistItemPrevious @"RVApplicationCommandPlaylistItemPrevious"
#define RVApplicationCommandMediaNext @"RVApplicationCommandMediaNext"
#define RVApplicationCommandMediaPrevious @"RVApplicationCommandMediaPrevious"

#define RVApplicationCommandGetCuedMedia @"RVApplicationCommandGetCuedMedia"
#define RVApplicationCommandGetCuedMediaParamMediaID @"RVApplicationCommandGetCuedMediaParamMediaID"
#define RVApplicationCommandGetCuedMediaParamCurrentTime @"RVApplicationCommandGetCuedMediaParamCurrentTime"
#define RVApplicationCommandGetCuedMediaParamDuration @"RVApplicationCommandGetCuedMediaParamDuration"
#define RVApplicationCommandGetCuedMediaParamRemaining @"RVApplicationCommandGetCuedMediaParamRemaining"

#define RVApplicationCommandGetCuedPresentation @"RVApplicationCommandGetCuedPresentation"
#define RVApplicationCommandGetCuedPlaylistItem @"RVApplicationCommandGetCuedPlaylistItem"
#define RVApplicationCommandGetCuedAudio @"RVApplicationCommandGetCuedAudio"

#define RVApplicationCommandListMedia @"RVApplicationCommandListMedia"
#define RVApplicationCommandListPresentation @"RVApplicationCommandListPresentation"
#define RVApplicationCommandListPlaylist @"RVApplicationCommandListPlaylist"
#define RVApplicationCommandListAudio @"RVApplicationCommandListAudio"

#define RVApplicationCommandListMediaParamMediaFiles @"RVApplicationCommandListMediaParamMediaFiles"

#define RVApplicationCommandQueryMedia					@"RVApplicationCommandQueryMedia"
#define RVApplicationCommandQueryMediaArray				@"RVApplicationCommandQueryMediaArray"
#define RVApplicationCommandQueryMediaFileName			@"RVApplicationCommandQueryMediaFileName"
#define RVApplicationCommandQueryMediaDuration			@"RVApplicationCommandQueryMediaDuration"
#define RVApplicationCommandQueryMediaInPoint			@"RVApplicationCommandQueryMediaInPoint"
#define RVApplicationCommandQueryMediaOutPoint			@"RVApplicationCommandQueryMediaOutPoint"
#define RVApplicationCommandQueryMediaSize				@"RVApplicationCommandQueryMediaSize"
#define RVApplicationCommandQueryMediaDateModified		@"RVApplicationCommandQueryMediaDateModified"
#define RVApplicationCommandQueryMediaSerialNumber		@"RVApplicationCommandQueryMediaSerialNumber"
#define RVApplicationCommandQueryMediaThumbnail			@"RVApplicationCommandQueryMediaThumbnail"

#define RVApplicationGetState @"RVApplicationGetState"

#define RVApplicationStateClear @"RVApplicationStateClear"
#define RVApplicationStatePlay @"RVApplicationStatePlay"
#define RVApplicationStateStop @"RVApplicationStateStop"
#define RVApplicationStateStill @"RVApplicationStateStill"
#define RVApplicationStateRewind @"RVApplicationStateRewind"
#define RVApplicationStateFastForward @"RVApplicationStateFastForward"
#define RVApplicationStatePrerolling @"RVApplicationStatePrerolling"


#define RVApplicationCommandDMXValuesChanged @"RVApplicationCommandDMXValuesChanged"


#define RVApplicationCommandMIDINote @"RVApplicationCommandMIDINote"
#define RVApplicationCommandMIDIParameterNote @"note"
#define RVApplicationCommandMIDIParameterState @"state"
#define RVApplicationCommandMIDIParameterIntensity @"intensity"
#define RVApplicationCommandMIDIParameterChannel @"channel"

#define RVApplicationCommandMIDINotes @"RVApplicationCommandMIDINotes"
#define RVApplicationCommandMIDIParameterNotes @"notes"


#define RVApplicationCommandGPITrigger @"RVApplicationCommandGPITrigger"
#define RVApplicationCommandGPIParameterInputNumber @"RVApplicationCommandGPIParameterInputNumber"
#define RVApplicationCommandGPIParameterState @"RVApplicationCommandGPIParameterState"

#define RVApplicationCommandGPOTrigger @"RVApplicationCommandGPOTrigger"
#define RVApplicationCommandGPOParameterInputNumber @"RVApplicationCommandGPOParameterInputNumber"
#define RVApplicationCommandGPOParameterState @"RVApplicationCommandGPOParameterState"



#endif
